/*
 スポット編集
*/

$(document).ready(function(){
	var map;
	var marker;

	spot_map_initialize();
	spot_edit_initialize();
});



/*
 地図の初期設定
*/
function spot_map_initialize() {
	//
	//初期データ
	//
	if ($("#lat").val()=="" || isNaN($("#lat").val()))
		$("#lat").val(36.204824);
	if ($("#lng").val()=="" || isNaN($("#lng").val()))
		$("#lng").val(138.252924);
	if ($("#zoom").val()=="" || isNaN($("#zoom").val()))
		$("#zoom").val(4);

	$("#map_lat").html($("#lat").val());
	$("#map_lng").html($("#lng").val());
	$("#map_zoom").html($("#zoom").val());


	//
	//地図表示
	//
	var center = new google.maps.LatLng($("#lat").val(), $("#lng").val());

	var mapOptions = {
		zoom: parseInt($("#zoom").val()),
		center: center,
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		mapTypeControl: true,
		mapTypeControlOptions: {
			style: google.maps.MapTypeControlStyle.DROPDOWN_MENU
		},
		navigationControl: true,
		navigationControlOptions: {
			style: google.maps.NavigationControlStyle.ZOOM_PAN
		},
		streetViewControl: false,
		scrollwheel: false
	};

	map = new google.maps.Map($("#map_canvas").get(0), mapOptions);      

	//
	//マーカー表示
	//
	marker = new google.maps.Marker({
		position: center,
		map: map,
		title: $("#name").val(),
		clickable: false
	});


	//
	//地図の中心の移動時
	//
	google.maps.event.addListener(map, 'center_changed', function() {
		marker.setPosition(map.getCenter());
		$("#lat").val(map.center.lat());
		$("#lng").val(map.center.lng());
		$("#map_lat").html(map.center.lat());
		$("#map_lng").html(map.center.lng());
	});

	//
	//ズームの変更時
	//
	google.maps.event.addListener(map, 'zoom_changed', function() {
		$("#zoom").val(map.getZoom());
		$("#map_zoom").html(map.getZoom());
	});

	//
	//マーカーのクリック時
	//
//	google.maps.event.addListener(marker, 'click', function() {
//	});

}


/*
 スポット編集の初期設定
*/
function spot_edit_initialize() {
	//
	//場所へ地図を移動させるボタン
	//
	$("#btn_mapSearch").click(function (){
		var geocoder = new google.maps.Geocoder();
		geocoder.geocode(
			{address: $("#address").val(), language: "ja", country: "JP"},
			function(results, status) {
				if (status == google.maps.GeocoderStatus.OK) {
					map.setCenter(results[0].geometry.location);
					marker.setPosition(results[0].geometry.location);
					if (map.getZoom()<10)
						map.setZoom(10);
				} else {
					alert("場所に該当する地図は見つかりません。(" + status + ")");
				}
			}
		);
	});

	//
	//地図から場所表記の取得ボタン
	//
	$("#btn_mapAddress").click(function (){
		//緯度経度から場所表記の取得
		var geocoder = new google.maps.Geocoder();
		geocoder.geocode(
			{latLng: map.getCenter(), language: "ja", country: "JP"},
			function(results, status) {
				if (status == google.maps.GeocoderStatus.OK) {
					var address;
					var i;
					for (i=0; i<results.length; i++) {
						//0:日本, 1:郵便番号 2:住所
						address = results[i].formatted_address.split(" ", 3).pop();
						if (address!="日本")
							break;
					}
					if (confirm("場所に設定しますか？\r\n"+address))
						$("#address").val(address);
				} else {
					alert("場所表記は見つかりません。(" + status + ")");
				}
			}
		);
	});

}